

PROCEDURE KRUSKAL(
       N,M               :INTEGER;
   VAR ENDV1,ENDV2,WEIGHT:ARRM;
   VAR CONNECT           :BOOLEAN;
   VAR TEDGE1,TEDGE2     :ARRN1;
   VAR TWEIGHT           :INTEGER);

   VAR I,LAST,U,V,R1,R2,ECOUNT,TCOUNT:INTEGER;
       FATHER                        :ARRN;

   PROCEDURE HEAP(FIRST,LAST:INTEGER);
      VAR J,K,TEMP1,TEMP2,TEMP3:INTEGER;
   BEGIN
      J:=FIRST;
      WHILE J <= TRUNC(LAST/2) DO BEGIN
         IF (2*J < LAST) AND (WEIGHT[2*J+1] < WEIGHT[2*J]) THEN
            K:=2*J+1
         ELSE K:=2*J;
         IF WEIGHT[K] < WEIGHT[J] THEN BEGIN
            TEMP1:=ENDV1[J];  TEMP2:=ENDV2[J];  TEMP3:=WEIGHT[J];
            ENDV1[J]:=ENDV1[K];  ENDV2[J]:=ENDV2[K];
            WEIGHT[J]:=WEIGHT[K];
            ENDV1[K]:=TEMP1;  ENDV2[K]:=TEMP2;
            WEIGHT[K]:=TEMP3;
            J:=K
         END  { IF WEIGHT[K] < WEIGHT[J] }
         ELSE J:=LAST
      END  { WHILE J <= TRUNC(LAST/2) }
   END;  { HEAP }

   FUNCTION FIND(I:INTEGER):INTEGER;
      VAR PTR:INTEGER;
   BEGIN
      PTR:=I;
      WHILE FATHER[PTR] > 0 DO PTR:= FATHER[PTR];
      FIND:=PTR
   END;  { FIND }

   PROCEDURE UNION(I,J:INTEGER);
      VAR X:INTEGER;
   BEGIN
      X:=FATHER[I]+FATHER[J];
      IF FATHER[I] > FATHER[J] THEN BEGIN
         FATHER[I]:=J;  FATHER[J]:=X
      END
      ELSE BEGIN
         FATHER[J]:=I;  FATHER[I]:=X
      END
   END;  { UNION }

BEGIN                                                   { MAIN BODY }
   FOR I:=1 TO N DO FATHER[I]:=-1;
   FOR I:=TRUNC(M/2) DOWNTO 1 DO                     { INITIAL HEAP }
      HEAP(I,M);
   LAST:=M;
   ECOUNT:=0;  TCOUNT:=0;
   TWEIGHT:=0;  CONNECT:=TRUE;                { INITIALIZATION OVER }
   WHILE ((TCOUNT < N-1) AND (ECOUNT < M)) DO BEGIN
      ECOUNT:=ECOUNT+1;
      U:=ENDV1[1];  V:=ENDV2[1];
      R1:=FIND(U);  R2:=FIND(V);
      IF R1 <> R2 THEN BEGIN                 { INCLUDE (U,V) IN MST }
         TCOUNT:=TCOUNT+1;  UNION(R1,R2);
         TEDGE1[TCOUNT]:=U;  TEDGE2[TCOUNT]:=V;
         TWEIGHT:=TWEIGHT+WEIGHT[1]
      END;  { IF R1 <> R2 }
      ENDV1[1]:=ENDV1[LAST];  ENDV2[1]:=ENDV2[LAST];
      WEIGHT[1]:=WEIGHT[LAST];
      LAST:=LAST-1;
      HEAP(1,LAST)
   END;  { WHILE ((TCOUNT < N-1) ... - ITERATION }
   IF TCOUNT <> N-1 THEN CONNECT:=FALSE
END;  { KRUSKAL }

